import numpy as np

def euclidean_1d_profile(
        num_voters,
        num_candidates,
        lower_radius,
        upper_radius
):

    # sampler points from 1D Euclidean space
    v_points = []
    c_points = np.random.uniform(0, 1, num_candidates)
    c_radius = np.random.uniform(lower_radius, upper_radius, num_candidates)

    # each voter votes for all the candidates with range 0.1
    P = np.zeros((num_voters, num_candidates))

    i = 0
    while len(v_points) < num_voters:
        v = np.random.uniform(0, 1)
        # r = np.random.uniform(lower_radius, upper_radius)
        for j, c in enumerate(c_points):
            # P[i][j] = 1 if np.abs(v - c) < r else 0
            P[i][j] = 1 if np.abs(v - c) < c_radius[j] else 0
        if np.sum(P[i]) > 0:
            v_points.append(v)
            i += 1

    return P, v_points, c_points, c_radius


def euclidean_2d_profile(
        num_voters,
        num_candidates,
        lower_radius,
        upper_radius
):
    v_points = []

    # sampler points from 2D Euclidean space
    c_points = np.random.uniform(0, 1, (num_candidates, 2))
    c_radius = np.random.uniform(lower_radius, upper_radius, num_candidates)

    # each voter votes for all the candidates with range 0.1
    P = np.zeros((num_voters, num_candidates))

    i = 0
    while len(v_points) < num_voters:
        v = np.random.uniform(0, 1, (1, 2))
        # r = np.random.uniform(lower_radius, upper_radius)
        for j, c in enumerate(c_points):
            # compute Euclidean distance between v and c
            P[i][j] = 1 if np.linalg.norm(v - c) < c_radius[j] else 0
        if np.sum(P[i]) > 0:
            v_points.append(v[0])
            i += 1

    # print average number of votes per voter
    print(np.sum(P, axis=1).mean())

    return P, v_points, c_points, c_radius


def euclidean_3d_profile(
        num_voters,
        num_candidates,
        lower_radius,
        upper_radius
):
    # candidate have radiuses, and voters don't

    v_points = []

    # sampler points from 2D Euclidean space
    c_points = np.random.uniform(0, 1, (num_candidates, 3))
    c_radius = np.random.uniform(lower_radius, upper_radius, num_candidates)

    # each voter votes for all the candidates with range 0.1
    P = np.zeros((num_voters, num_candidates))

    i = 0
    while len(v_points) < num_voters:
        v = np.random.uniform(0, 1, (1, 3))
        # r = np.random.uniform(lower_radius, upper_radius)
        for j, c in enumerate(c_points):
            # compute Euclidean distance between v and c
            P[i][j] = 1 if np.linalg.norm(v - c) < c_radius[j] else 0
        if np.sum(P[i]) > 0:
            v_points.append(v[0])
            i += 1

    # print average number of votes per voter
    print(np.sum(P, axis=1).mean())

    return P, v_points, c_points, c_radius
